<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\IndexController;
use App\Http\Controllers\EntrepriseController;
use App\Http\Controllers\GareController;
use App\Http\Controllers\RegdemandeENCController;
use App\Http\Controllers\RegdemandeENDController;
use App\Http\Controllers\RegdemandeANNController;
use App\Http\Controllers\HoraireController;
use App\Http\Controllers\PersonneController;
use App\Http\Controllers\PointageController;
use App\Http\Controllers\RechercheController;
use App\Http\Controllers\SuiviController;
use App\Http\Controllers\UtilisateurController;
use App\Http\Controllers\VehiculeController;
use App\Models\Suivi;
use App\Models\SuiviVehicule;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});

Route::get('/home', [IndexController::class, 'home'])->name('home'); 
Route::post('editgare', [GareController::class, 'editerGare'])->name('editegare');
Route::post('addline', [GareController::class, 'ajouterLigne'])->name('ajoutligne');
Route::post('listline', [GareController::class, 'listerLigne'])->name('listligne');

Route::post('editvehicule', [IndexController::class, 'editerVehicule'])->name('editvehicule');
Route::post('editeuser', [UtilisateurController::class, 'editeUser'])->name('editeuser');
Route::post('consultdemande', [IndexController::class, 'consulterDemande'])->name('consultdemande');
Route::post('consultvehicule', [IndexController::class, 'consultvehicule'])->name('consultvehicule');
Route::post('listeenChauffeurs', [RegdemandeENCController::class, 'listChauffeur'])->name('getchauffeur');
Route::post('listeenVehicules', [RegdemandeENDController::class, 'listVehicule'])->name('getvehicule');
Route::post('listeenLine', [RegdemandeANNController::class, 'listLigne'])->name('getlignes');
Route::post('editligne', [RegdemandeANNController::class, 'editerLigne'])->name('editeligne');

Route::resource('gare', GareController::class);
Route::resource('vehicule', VehiculeController::class);
Route::post('dtvehicule', [VehiculeController::class, 'editerVehicule'])->name('editevehicule');
Route::resource('suivi', SuiviController::class);
Route::resource('personne', PersonneController::class);
Route::post('editeperson', [PersonneController::class, 'editerPersonne'])->name('editepersonn');

Route::resource('recherche', RechercheController::class);


Route::resource('utilisateur', UtilisateurController::class);
Route::resource('registrechauff', RegdemandeENCController::class);
Route::resource('registrevehicule', RegdemandeENDController::class);
Route::resource('registrelignes', RegdemandeANNController::class);

Route::get('/detailDemande/{id}', [RegdemandeENCController::class, 'detailcommande'])->name('detailBycommande');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
