@extends('layouts.index')
@section('content')

<div class="pagetitle">
    <h1>GESTION UTILISATEUR</h1>
</div><!-- End Page Title -->

<section class="section">
    @if ($message = Session::get('success'))
    <div class="alert alert-success alert-block">
        <button type="button" class="close" data-dismiss="alert">×</button>
        <strong>{{ $message }}</strong>
    </div>
    @endif
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Informations...</h5>
                    <!-- General Form Elements -->
                    <form action="{{ url('/utilisateur') }}" method="POST">
                        @csrf
                        <div class="row col-lg-12">
                            <div class="col-lg-12">
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">NOM:</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="nom" class="form-control">
                                    </div>
                                    <label class="col-sm-2 col-form-label">TELEPHONE :</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="telephone" class="form-control">
                                    </div>
                                   
                                </div>
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">E-MAIL:</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="email" class="form-control">
                                    </div>
                                    <label class="col-sm-2 col-form-label">SPECIALITE : </label>
                                    <div class="col-sm-4">
                                        <select class="form-select" name="domaine" aria-label="Default select example">
                                           
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <!--label class="col-sm-2 col-form-label">LOGIN:</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="login" class="form-control">
                                    </div-->
                                    <!--label class="col-sm-2 col-form-label">PAYS : </label>
                                    <div class="col-sm-4">
                                        <select class="form-select" name="pays" aria-label="Default select example">
                                            <option selected>Choisir Ici</option>
                                            <option value="COTE D'IVOIR">COTE D'IVOIR</option>
                                            <option value="BENIN">BENIN</option>
                                            <option value="TOGO">TOGO</option>
                                            <option value="GHANA">GHANA</option>
                                        </select>
                                    </div-->
                                </div>
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="col-lg-4">
                            </div>
                            <div class="col-lg-4">
                                <div class="row mb-3">
                                    <div class="col-sm-10">
                                        <button type="submit" class="btn btn-danger">AJOUTER</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="row mb-3">
                                    <div class="col-sm-10">
                                        <button type="submit" class="btn btn-warning">ANNULER</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!-- End General Form Elements -->
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">LISTE DES UTILISATEURS</h5>
                    <table class="table datatable">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col"> NOM </th>
                                <th scope="col">LOGIN </th>
                                <th scope="col">TYPE </th>
                                <th scope="col">MDP </th>
                                <th scope="col">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($utilisateurs as $user)
                            <tr>
                                <th scope="row"> </th>
                                <td>{{ $user->city->name }}</td>
                                <td>{{ $user->login_user }}</td>
                                <td>{{ $user->domaine }}</td>
                                <td>{{ $user->password_user }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-danger dropdown-toggle btn-sm" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                            Actions
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            <li>
                                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#editeuser_{{ $user->id }}">Edit MDP</a>
                                            </li>
                                        </ul>
                                    </div>

                                    {{-- Modal POUR MESSAGE --}}
                                    <form action="{{route('editeuser')}}" method="POST">
                                        @csrf
                                        {{--@method('PUT')--}}
                                        <div class="modal fade" id="editeuser_{{ $user->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">MISE A JOUR</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <input type="hidden" value="{{ $user->id }}" name="id">
                                                        <div class="row mb-3">
                                                            <div class="col-sm-8">
                                                                </br>
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">Email/Login :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $user->login_user }}" name="login" class="form-control" >
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">Password :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $user->password_user }}" name="password" class="form-control">
                                                            </div>
                                                        </div>
 
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary">Valider</button>
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fermer</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                    {{-- Modal POUR MESSAGE--}}
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</section>
@endsection
