@extends('layouts.index')
@section('content')

<div class="pagetitle">
    <h1>REGISTRES</h1>
</div><!-- End Page Title -->

<section class="section">

    @if ($message = Session::get('success'))
    <div class="alert alert-success alert-block">
        <button type="button" class="close" data-dismiss="alert">×</button>
        <strong>{{ $message }}</strong>
    </div>
    @endif

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">LISTE DES CHAUFFEURS</h5>
                    <!-- Table with stripped rows -->
                    <table class="table datatable">
                        <thead>
                            <tr>
                                <tr>
                                    <th scope="col">NOM-PRENOM(S)</th>
                                    <th scope="col">PERMIS</th>
                                    <th scope="col">TELEPHONE</th>
                                    <th scope="col">ADRESSE</th>
                                    <th scope="col">SEXE</th>
                                    <th scope="col">NATIONALITE</th>
                                    <th scope="col">ACTION</th>
                                </tr>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($allChauffeurs as $chauffeur)
                            <tr>
                                <td>{{ $chauffeur->personne->nom}} {{ $chauffeur->personne->prenom}}</td>
                                <td>{{ $chauffeur->personne->telephone }} </td>
                                <td>{{ $chauffeur->personne->adresse }} </td>
                                <td>{{ $chauffeur->permis }} </td>
                                <td>{{ $chauffeur->personne->sexe}}</td>
                                <td>{{ $chauffeur->personne->nationalite}}</td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-danger dropdown-toggle btn-sm" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                            Actions
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            <li>
                                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#annDemande_{{ $chauffeur->id }}">Infos +</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#endDemande_{{ $chauffeur->id }}">Modifier</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#endDemande_{{ $chauffeur->id }}">Supprimer</a>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!-- End Table with stripped rows -->
                    <div class="row mb-3">

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection
