@extends('layouts.index')
@section('content')

<div class="pagetitle">
    <h1>GESTION DES POINTAGES</h1>
</div><!-- End Page Title -->

<section class="section">
    @if ($message = Session::get('success'))
    <div class="alert alert-success alert-block">
        <button type="button" class="close" data-dismiss="alert">×</button>
        <strong>{{ $message }}</strong>
    </div>
    @endif
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Informations...</h5>
                    <!-- General Form Elements -->
                    <form action="{{ url('/suivi') }}" method="POST">
                        @csrf
                        <div class="row col-lg-12">
                            <div class="col-lg-12">
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">GARES :</label>
                                    <div class="col-sm-4">
                                        <select class="form-select" name="jour" aria-label="Default select example">
                                                <option selected>Choisir Ici</option>
                                               @foreach($allgares as $gare)
                                                <option value="{{$gare->id }}">{{ $gare->nom_gare }}</option>
                                              @endforeach
                                            </select>
                                    </div>

                                    <label class="col-sm-2 col-form-label">VEHICULES :</label>
                                    <div class="col-sm-4">
                                        <select class="form-select" name="gare_id" aria-label="Default select example">
                                            <option selected>Choisir Ici</option>
                                            @foreach($allVehicules as $vehicule)
                                                <option value="{{$vehicule->id }}">{{ $vehicule->num_chassi }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">CHAUFFEURS :</label>
                                    <div class="col-sm-4">
                                        <select class="form-select" name="gare_id" aria-label="Default select example">
                                            <option selected>Choisir Ici</option>
                                            @foreach($allChauffeurs as $chauffeur)
                                                <option value="{{$chauffeur->id }}">{{ $chauffeur->nom }} - {{ $chauffeur->prenom }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <label class="col-sm-2 col-form-label">DATE JOUR :</label>
                                    <div class="col-sm-4">
                                        <input type="date" name="day" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">NOTE :</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="remarque" class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="col-lg-4">
                            </div>
                            <div class="col-lg-4">
                                <div class="row mb-3">
                                    <div class="col-sm-10">
                                        <button type="submit" class="btn btn-danger">ENREGISTRER</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="row mb-3">
                                    <div class="col-sm-10">
                                        <button type="submit" class="btn btn-warning">ANNULER</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!-- End General Form Elements -->
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">LISTE DES POINTAGES</h5>
                    <table class="table datatable">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">GARE </th>
                                <th scope="col">CHAUFFEUR </th>
                                <th scope="col">VEHICULE </th>
                                <th scope="col">DATE JOUR </th>
                                <th scope="col">POSITION </th>
                                <th scope="col">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($allPointages as $pointage)
                            <tr>
                                <th scope="row"> </th>
                                <td></td>
                                <td></td>
                                 <td></td>
                                <td></td>
                                <td></td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-danger dropdown-toggle btn-sm" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                            Actions
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            <li>
                                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#editentreprise_{{ $entreprise->id }}">Modifier</a>
                                            </li>
                                        </ul>
                                    </div>
                                    {{-- Modal POUR EDITER --}}
                                    
                                    {{-- Modal POUR EDITER--}}
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
