<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gare extends Model
{
    use HasFactory;

    protected $fillable = ['nom_gare', 'ville_gare', 'contact', 'responsable', 'latitude', 'longitide'];

    public function commune()
    {
        return $this->belongsTo(Commune::class, 'ville_gare');
    }

    public function personne()
    {
        return $this->belongsTo(Personne::class, 'responsable');
    }

    public function lignes()
    {
       return $this->hasMany(Ligne::class);
    }
}
