<?php


namespace App\Http\Controllers;

use App\Models\Commune;
use App\Models\Ligne;
use App\Models\Personne;
use App\Models\Reservation;
use App\Models\TimeSlot;
use Illuminate\Http\Request;

class RegdemandeANNController extends Controller
{
    //
    public function index(){
        $listLignes = Ligne::orderByDesc('created_at')->with('gare')->with('personne')
                            ->get();
        $allCommunes = Commune::all();
        $allPersonnes = Personne::all();
        return view('regdemandeANN' , [
                 'listLignes' => $listLignes,
                 'allCommunes' => $allCommunes,
                 'allPersonnes' => $allPersonnes
        ]);
    }

   
    public function editerLigne(Request $request)
    {

            $selectLigne = Ligne::find($request->id);
            $selectLigne->update(['ville_deb' => $request->ville_deb . '-' .$request->quartier_deb,
            'ville_fin' =>$request->ville_fin . '-' . $request->quartier_arr,
            'nom_ligne' =>$request->nom_ligne,
            'distance' =>$request->cout,
            'gare_id' =>$request->gare,
            'personne_id' =>$request->personne_id,
           ]);
           return redirect()->back()->with('success', 'Opération effectuée avec succès !');
    }
}
