<?php

namespace App\Http\Controllers;

use App\Models\Personne;
use Illuminate\Http\Request;

class PersonneController extends Controller
{
    //
    public function index()
    {
        $allPersonnes = Personne::all();
        return view('personne',[
            'allPersonnes' => $allPersonnes
        ]);
    }

     public function store(Request $request)
    {
        try {
        $data = request()->validate([
            'nom' => ['required', 'string'], 
            'prenom' => ['required', 'string'], 
            'groupesanguin' => ['required', 'string'], 
            'sexe' => ['required', 'string'], 
            'telephone' => ['required', 'string'],
            'nationalite' => ['required', 'string'],
            'adresse' => ['required', 'string'],
            'email' => ['required', 'string']
        ]);
        
        $data['nom'] = $request->nom;
        $data['prenom'] = $request->prenom;
        $data['groupesanguin'] = $request->groupesanguin;
        $data['sexe'] = $request->sexe;
        $data['telephone'] = $request->telephone;
        $data['nationalite'] = $request->nationalite;
        $data['adresse'] = $request->adresse;
        $data['email'] = $request->email;
        Personne::create($data);

        } catch (\Throwable $th) {
            dd($th->getMessage());
        }
        
        return redirect('/personne')->with('success', 'Opération effectuée avec succès');
    }

    public function editerPersonne(Request $request)
    {
            $selectPersonn = Personne::find($request->id);
            $selectPersonn->update(['nom' => $request->nom,
            'prenom' =>$request->prenom,
            'sexe' =>$request->sexe,
            'telephone' =>$request->telephone,
            'groupesanguin' =>$request->gpsanguin,
            'adresse' =>$request->adresse,
            'nationalite' =>$request->nationalite,
            'email' =>$request->email
           ]);
           return redirect()->back()->with('success', 'Opération effectuée avec succès !');
    }

}
